# 我的 AI 工具箱推荐

> 我今年用的最多的 AI 产品 Top 20



你好，我是程序员鱼皮，前腾讯全栈开发，全网 200 万粉的 [AI 编程博主](https://space.bilibili.com/12890453)，也是 [AI 导航](https://ai.codefather.cn) 和 [编程导航](https://www.codefather.cn) 等 10+ 自研产品的创造者。

在前面的文章中，我们系统学习了 AI 编程工具的各个类型：从 AI 模型选择、零代码平台、AI 代码编辑器、命令行工具、IDE 插件、AI 智能体平台，到辅助工具集。

那问题来了：

- 这么多工具，鱼皮你自己到底用哪些？
- 实际工作中，这些工具怎么搭配使用？
- 有没有一些实战经验可以分享？

这篇文章，我会分享 2025 年我使用最多的 AI 产品 Top 20，以及我的实际使用心得，希望能给你一些参考。



## 一、AI 编程工具

作为一名程序员，AI 编程工具是我用得最多的。下面是我今年的主力编程工具。



### Cursor

[Cursor](https://cursor.com/) 是我心中开发体验和 AI 工程能力 Top 1 的 AI 编辑器。做大项目主要靠它，无论是写代码、改代码、还是重构代码，Cursor 的 Agent 模式都能帮我搞定。

我特别喜欢它的 Tab 补全功能，写代码的时候 AI 会自动预测我要写什么，按 Tab 就能接受建议。这种感觉就像有个老司机坐在旁边，你刚想到要写什么，他就已经帮你写好了。

而且 Cursor 可以自由切换 Claude、GPT、Gemini 等多个模型，还能使用自己的 API Key，我可以根据不同任务选择最合适的模型。

不过 Cursor 最大的问题就是价格死贵。我之前分享过账单，一个多月就烧了 1 万多块。所以我现在会搭配一些免费工具使用，避免预算爆炸。

![](https://pic.yupi.icu/1/yupicursorbilling.png)



### Claude Code

[Claude Code](https://claude.ai/code) 是我用的最多的命令行 AI 编程工具。它的自动化程度非常高，不仅能生成代码，还能自动执行命令、安装依赖、创建文件。

我一般用它来做一些简单的任务，或者快速搭建项目框架。比如我想做一个图片压缩工具，直接在命令行里跟 AI 说一句话，它就能自动帮我搭好整个项目。

![](https://pic.yupi.icu/1/1764146174167-3018c8f3-0ad9-4a4f-9764-246f33b33203.png)

而且 Claude Code 支持 Skills，可以把一些常用的规范和流程写成 Skill，让 AI 自动遵循，对于避免重复工作和团队协作特别有用。

因为 Claude Code 在国内有限制，我一般会配合国产 AI 大模型使用，比如智谱 GLM。这样既能正常使用，成本也更低。



### Cline

[Cline](https://cline.bot/) 是一款 AI IDE 插件，是我的备胎之一。当 Cursor 的预算用完了，或者我想在 VS Code 里开发时，就会用 Cline。

![](https://pic.yupi.icu/1/image-20260108222935455.png)

Cline 最大的优势是完全免费，而且功能很全面，基本上能做到 Cursor 80% 的事情。虽然体验没有 Cursor 那么流畅，但考虑到它是免费的，已经非常不错了。

而且 Cline 支持多个平台，不仅是 VS Code、JetBrains 系列也能用。这意味着我在不同编辑器之间切换时，都能用同一个工具，保持一致的体验。



## 二、AI 多媒体创作工具

除了编程，我还会用 AI 做内容创作。下面是我用得最多的多媒体创作工具。



### Nano Banana

Nano Banana 是今年最炸裂的 AI 生图工具，我用它来生成漫画知识讲解图片和文章封面图。

它对中文的支持特别好，不像 Midjourney 那样需要用英文提示词。而且生成的图片风格很统一，特别适合做教程配图。

你看到的这种动漫风格的图片，都是用 Nano Banana 做的：

![](https://pic.yupi.icu/1/toolstype%25E5%25A4%25A7.jpeg)

自从用了 Nano Banana，我就彻底和 Midjourney 说再见了。



### 即梦 AI

[即梦 AI](https://jimeng.jianying.com/) 是字节的一站式 AI 创作平台，支持文字生图、图生视频等功能。

我主要用它来生成视频空镜画面。比如我做教程视频时，需要一些背景画面，就会用即梦 AI 生成。它的视频生成速度很快，而且质量不错。

而且即梦 AI 是国产平台，访问速度快，也不用担心被墙的问题。



### Veo 3

[Veo 3](https://aistudio.google.com/models/veo-3) 是 Google 最先进的 AI 视频生成模型，我用它来做一些有创意的短视频。

Veo 3 的视频质量确实很高，物理规律、光影效果都很真实。但是价格死贵，所以我只在需要高质量视频的时候才会用它。

![](https://pic.yupi.icu/1/1751177650505-09aecbd1-a858-4a01-a74d-62120f074c98.png)



### Eleven Labs

[Eleven Labs](https://elevenlabs.io/) 是 AI 语音合成工具，模仿声音效果特别逼真。

而且 Eleven Labs 支持多种语言和声音风格，可以根据不同场景选择不同的声音，我会用它来合成一些创意视频的配音。

![](https://pic.yupi.icu/1/image-20260109100507368.png)



## 三、AI 大模型

AI 大模型是所有 AI 工具的基础。下面是我今年用得最多的几个大模型。



### 智谱 GLM

[智谱 GLM](https://bigmodel.cn/) 是我用得最多的国产大模型，编程能力很强，中文理解能力也很优秀。

我主要用它搭配 Claude Code 生成非商业级的全栈项目。因为 GLM 的 API 价格很便宜，而且速度快，特别适合做一些小项目或者快速验证想法。

如今智谱的发展也是嘎嘎猛，从 GLM-4.6 开始编程能力就有了很大提升，在一些测评中甚至超过了 Claude Sonnet！公司上市也是理所应当的。



### 阿里通义千问

通义千问是我们团队产品接入最多的大模型。它的优势是生成速度快、API 对接方便，还可以利用 [阿里云百炼平台](https://bailian.console.aliyun.com/) 调试。

![](https://pic.yupi.icu/1/1752569401445-7023e2c1-f709-4c22-af86-63ee1872c1cd.png)

我们的产品用它来生成简单的内容或者做意图识别。比如用户输入一句话，我们用通义千问来判断用户想做什么，然后调用相应的功能。

而且通义千问有免费额度，对于小项目来说够用一阵子了。



### DeepSeek

[DeepSeek](https://www.deepseek.com/) 作为曾经是爆款，完全免费而且编程能力很强。不过最近无论是产品生态还是出新模型的速度都略逊一筹。

我现在主要用它来校验专业技术知识。比如我写文章时，不确定某个技术点是否正确，就会问问 DeepSeek。反正它是免费的，所以我可以随便问，不用担心成本。

![](https://pic.yupi.icu/1/image-20260109100658239.png)



### Gemini

[Gemini](https://gemini.google.com/) 具备强大的推理能力和多模态理解能力，而且支持超长上下文（100 万 Token）。

我主要用它来分析大型项目。比如我接手一个几百个文件的项目，想快速了解项目结构，就会用 Gemini 来分析。

我还会利用 Gemini 网页版来搜集一些国外的技术和产品调研，给出的报告很专业。

![](https://pic.yupi.icu/1/image-20260109100840547.png)

不过 Gemini 在国内有一定的使用门槛，你懂的。



## 四、AI 开发框架

除了直接使用 AI 工具，我还会用一些 AI 开发框架来构建 AI 应用。



### Spring AI

[Spring AI](https://spring.io/projects/spring-ai) 是 Java AI 开发的标配，提供统一 API 简化大模型集成。

我们团队做 Java 项目时，基本上都会用 Spring AI。它把各种大模型的 API 统一成一套接口，这样开发者可以很方便地切换不同的模型，不用改代码。

![](https://pic.yupi.icu/1/image-20260109100909041.png)

而且 Spring AI 提供了很多高级功能，比如对话记忆、RAG、工具调用等，让我们可以快速构建复杂的 AI 应用。



### LangChain4j

[LangChain4j](https://docs.langchain4j.dev/intro) 是 Java 版的 LangChain，支持声明式语法，开发体验巨爽，适合构建复杂 Agent。

我特别喜欢它的链式调用语法，写起来很优雅。而且它的文档很完善，社区也很活跃，遇到问题可以到 GitHub Issues 区多看看，容易找到解决方案。

我带 [编程导航](https://codefather.cn/) 的鱼友们做对标大厂的 [AI 零代码生成平台项目](https://www.codefather.cn/course/1948291549923344386) 时，就是用的 LangChain4j + LangGraph4j，能够很方便地构建复杂的 AI 工作流。

![](https://pic.yupi.icu/1/1753332332820-9ec614de-65a2-496d-b9b2-dc89c20d06c9.png)



### Vercel AI Gateway

[Vercel AI Gateway](https://vercel.com/ai-gateway) 是 AI 模型网关服务，让你能统一调用数百个 AI 模型。

它提供了统一的 API，我不用去学习每个模型的 API 文档，直接用 Vercel AI Gateway 就行。

![](https://pic.yupi.icu/1/1760687990497-90720fbb-0df6-4ede-87b8-64b8702994e9-20251028181254840.png)

我用它来开发一些创意项目。比如我想做一个 AI 工具，让用户可以选择不同的模型，Vercel AI Gateway 就能帮我很方便地实现这个功能。



### 阿里云百炼

[阿里云百炼](https://bailian.console.aliyun.com/) 是企业级 AI 应用开发平台，支持 RAG 知识库、流程编排等功能。

我们团队的一些知识库就用它来管理。比如我们有很多技术文档，用百炼的 RAG 功能可以很方便地让 AI 基于这些文档回答问题。

![](https://pic.yupi.icu/1/1744177887403-6373c63c-d410-49ba-a71c-556389536376.png)

而且百炼提供了可视化的流程编排功能，不用写代码就能构建复杂的 AI 工作流。

![](https://pic.yupi.icu/1/1745388167957-d7995436-fc2f-410e-bc59-4f6db6544359.png)



### OpenRouter

[OpenRouter](https://openrouter.ai/) 是统一的 AI 模型路由平台。它支持几百个模型，而且可以很方便地切换，不用去每个平台注册账号。

每次有新模型发布，我都会在 OpenRouter 上试试，用它来体验最新的大模型能力。

![](https://pic.yupi.icu/1/image-20260109101446266.png)

对于想要尝鲜的开发者来说，OpenRouter 是个很好的选择。



## 五、AI 浏览器插件

AI 浏览器插件让我可以在浏览器里随时使用 AI，特别方便。

### Monica

[Monica](https://monica.im/) 是浏览器里的全能 AI 助手，网页总结、视频总结、翻译、写作、图片处理一应俱全。

![](https://pic.yupi.icu/1/image-20260109101602426.png)

我每天都在用 Monica。比如看长文章时，用它总结一下核心内容；看英文文档时，用它翻译；看代码仓库时，总结整个项目的介绍。

![](https://pic.yupi.icu/1/image-20260109101803122.png)

Monica 最大的优势是集成度高，几乎所有常用的 AI 功能都有。而且它支持多个大模型，可以根据任务选择最合适的模型，强烈安利。



### AITDK

[AITDK](https://aitdk.com/) 是 SEO 和内容创作神器，我用它来进行关键词分析和竞品研究。

做自媒体的朋友都知道，关键词研究很重要。AITDK 可以帮我分析哪些关键词搜索量大、竞争小，然后我就针对这些关键词写文章、或者优化自己的网站。

而且 AITDK 还能分析竞品的内容策略，看看别人都在写什么，我就能找到差异化的角度。

![](https://pic.yupi.icu/1/image-20260109101947603.png)



## 六、AI 日常对话

除了工作，我平时也会用 AI 来解决一些日常问题。



### 字节豆包

字节豆包是国民级 AI 应用，速度快交互好。

我遇到问题时，经常会直接掏出手机找豆包问问。豆包的回答速度特别快，而且中文理解能力很强。



### 腾讯元宝

腾讯元宝最大的优势是打通了微信，随时随地都能用。

我在微信里看到一篇文章，想让 AI 总结一下，直接 @元宝 就行。这种无缝集成的体验特别好，不用切换 App，在微信里就能用 AI。

![](https://pic.yupi.icu/1/image-20260109102243168.png)



## 七、AI 办公工具

做内容创作时，我也会用一些 AI 办公工具来提高效率。



### 百度文心助手

[百度文心助手](https://image.baidu.com/) 集成了很多文档写作和图片处理工具，我经常用它改图和去水印。

比如我拍了一张照片，想去掉水印，用文心助手几秒钟就能搞定。或者我想把一张图片的背景换掉，文心助手也能帮我实现。

而且文心助手还有很多其他功能，比如 PPT 生成、文档翻译等。对于内容创作者来说，是个很实用的工具。

![](https://pic.yupi.icu/1/image-20260109102440839.png)



## 八、鱼皮 AI 导航

鱼皮团队开发的 [AI 导航网站](https://ai.codefather.cn/)，也是我今年访问最多的 AI 网站，一个字就是 “全”！

我会定期去看看最近 AI 领域有什么新动态。而且鱼皮 AI 导航整理了很多 AI 工具的分类，找工具特别方便。

![](https://pic.yupi.icu/1/AI%E8%B5%84%E6%BA%90%E5%A4%A7%E5%85%A8%E7%BD%91%E7%AB%99.png)



## 九、我的使用策略

分享了这么多工具，简单总结一下：

- **做大项目时**，我会用 Cursor + Claude Opus 4.5，因为代码质量要求高，需要最强的 AI 能力。

- **做小项目或快速验证想法时**，我会用 Claude Code + 智谱 GLM，因为速度快，成本低。

- **预算用完时**，我会切换到 VS Code + Cline + DeepSeek，完全免费，功能也够用。

- **需要生成图片时**，我会用 Nano Banana，因为中文支持好，生成速度快。

- **需要生成视频时**，我会根据质量要求选择即梦 AI（性价比高）或 Veo 3（质量最高）。

- **日常遇到问题时**，我会直接问豆包或元宝，因为方便快捷。

- **写文章需要配图时**，我会用文心助手处理图片，因为功能全面。

根据场景选择最合适的工具，这样既能保证效率，又能控制成本。



## 写在最后

这就是我今年使用最多的 AI 产品 Top 20，以及我的实际使用心得。

**工具会不断更新，选择要灵活。**

除了工具外，更重要的是，掌握 Vibe Coding 的核心能力：如何清楚地表达需求、如何与 AI 有效对话、如何理解和优化 AI 生成的代码、如何把想法变成产品。

现在你已经掌握了 Vibe Coding 所需的工具知识。接下来，是时候把这些工具用起来，做出真正的项目了！

在【项目实战】板块中，我会手把手带你做各种项目，从个人工具到 AI 应用，从简单到复杂，让你真正掌握 Vibe Coding 的精髓。



## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
